/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.util;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITag;
import tv.mapper.mapperbase.config.BaseConfig;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TagViewer {
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent e) {
        if (!((Boolean)BaseConfig.ClientConfig.ENABLE_TAG_VIEWER.get()).booleanValue()) {
            return;
        }
        if (!Screen.m_96637_()) {
            return;
        }
        List tooltips = e.getToolTip();
        IForgeRegistry itemsRegistry = ForgeRegistries.ITEMS;
        if (itemsRegistry.isEmpty() || itemsRegistry.tags() == null) {
            tooltips.add(new TextComponent("Item or tag registry is empty...").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.DARK_GRAY));
            return;
        }
        List tagList = itemsRegistry.tags().stream().toList();
        List stackKeys = e.getItemStack().m_204131_().toList();
        int count = 0;
        for (ITag tag : tagList) {
            if (!stackKeys.contains(tag.getKey())) continue;
            tooltips.add(new TextComponent("Tag: " + tag.getKey().toString()).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.DARK_GRAY));
            ++count;
        }
        if (count <= 0) {
            tooltips.add(new TextComponent("No tag found...").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }
}

